function clusterDist = computeClusterDistances(outputFile, outputDir, analyseLineages)
    
    load(outputFile); % uData
    
    load([outputDir uData.delimiter 'cluster_comparison.mat']);  % allPairwiseMarginals
    
    
    nClusters = max(uData.partition);
    clusterDist = zeros(nClusters,nClusters);
    
    for cluster1 = 1 : nClusters-1

        for cluster2 = cluster1+1 : nClusters

            %load([outputDir uData.delimiter prefix num2str(smallerInd) '_' num2str(largerInd) '.mat']);
            % marginals, logPosterior
            
            marginals = allPairwiseMarginals{cluster1, cluster2};
            % The first row of "marginals" is the probability that the two
            % clusters should be the same. The second row is the
            % probability that they are different.

            isSame = marginals(1,:) > 0.5;
            
            segments = identifySegments(isSame, 1, uData.snpPositions, uData.totalSequenceLength);
            segments = segments(segments(:,3)==1,:); % Segments where clusters are the same.
            
            if size(segments,1) > 0
                totalLengthOfSegments = sum(segments(:,2) - segments(:,1) + 1,1);
                clusterDist(cluster1, cluster2) = 1- totalLengthOfSegments ./ uData.totalSequenceLength;
            else
                clusterDist(cluster1, cluster2) = 1;
            end
            
            clusterDist(cluster2, cluster1) = clusterDist(cluster1, cluster2);
            
        end
    end
end