function clusterDist = computeAndPlotClusterSimilarities(outputFile,outputDir, delimiter, createPlot)
    % 'createPlot' is either true of false. If false, then no plotting is
    % done.

    load(outputFile); % uData
    nClusters = max(uData.partition);
    
    colors = distinguishable_colors(nClusters);
    cmap = colors(end:-1:1,:);
    cmap = brighten(cmap, 0.5);
    cmap(nClusters+1,:) = [1 1 1]; % Black color for the empty cluster.
    
    clusterDist = zeros(nClusters,nClusters);
    
    for clusterToPlot = 1:nClusters

        subplot(nClusters, 1, clusterToPlot);

        for otherCluster = 1:nClusters

            if otherCluster ~= clusterToPlot
                
                smallerInd = min(clusterToPlot, otherCluster);
                largerInd = max(clusterToPlot, otherCluster);
                load([outputDir delimiter 'clusters_' num2str(smallerInd) '_' num2str(largerInd) '.mat']);
                % marginals, logPosterior
                % The first row of "marginals" is the probability that the two
                % clusters should be the same. The second row is the
                % probability that they are different.

                isSame = marginals(1,:) > 0.5;
                
                set(gca,'YLim', [0 nClusters+1], 'XLim', [1 uData.totalSequenceLength+1]);

                segments = identifySegments(isSame, 1, uData.snpPositions, uData.totalSequenceLength);
                segments = segments(segments(:,3)==1,:); % Segments where clusters are the same.
                
                if size(segments,1) > 0
                    totalLengthOfSegments = sum(segments(:,2) - segments(:,1) + 1,1);
                    clusterDist(clusterToPlot, otherCluster) = 1- totalLengthOfSegments ./ uData.totalSequenceLength;
                    disp(num2str([clusterToPlot otherCluster]));
                    
                    y1 = otherCluster - 0.5;
                    y2 = otherCluster + 0.5;

                    color = cmap(otherCluster,:);

                    for i = 1:size(segments,1)

                        x1 = segments(i,1)-1;
                        x2 = segments(i,2);

                        patch([x1 x2 x2 x1], [y1 y1 y2 y2],color,'EdgeColor','none');
                    end
                else
                    clusterDist(clusterToPlot, otherCluster) = 1;
                end
                
            end

        end

    end
end


function plotSegments(yCoord, segments, segmentStart, segmentEnd, totalSequenceLength, cmap)
    
    nSegments = size(segments,1);
    totalLengthInCoordinates = segmentEnd - segmentStart;
    lengthRatio = totalLengthInCoordinates / totalSequenceLength;
    
    for segmentIndex = 1:nSegments
        
        lengthOfSegment = segments(segmentIndex,2) - segments(segmentIndex,1) + 1;
        lengthInCoordinates = lengthOfSegment .* lengthRatio;
        
        totalLengthOfSegmentsSoFar = segments(segmentIndex,1) - 1;
        totalLengthOfSegmentsSoFar = totalLengthOfSegmentsSoFar .* lengthRatio;
        
        x1 = segmentStart + totalLengthOfSegmentsSoFar;
        x2 = x1 + lengthInCoordinates;
        
        origin = segments(segmentIndex,3);
        if isempty(cmap)
            color = [0.8 0.8 0.8];
            edgeColor = [0.8 0.8 0.8];
        else
            color = cmap(origin,:);
            edgeColor = 'none';
        end
        patch([x1 x2 x2 x1], [yCoord+0.5 yCoord+0.5 yCoord-0.5 yCoord-0.5],color,'EdgeColor',edgeColor);
        
    end
    
end
