function preCalculatedTransMatrices = preCalculateTransMatrices(totalSequenceLength, transPars, nStates, snpPositions, numSmallestToPrevent)
% The function calculates powers 1,2,4,... of single step transition
% matrix.

if nargin==4
    numSmallestToPrevent = 0;
end

if ~isstruct(transPars)
    phi = transPars;
    rho = phi.^(1/(totalSequenceLength-1));
    % Rho is the probability that there is no change in a single step.
    
    nPossibleStates = nStates - numSmallestToPrevent;
    transitionProbsSingleStep = zeros(nStates);
    
    transitionProbsSingleStep(numSmallestToPrevent+1:end, numSmallestToPrevent+1:end) = ...
        eye(nStates-numSmallestToPrevent)*rho + (1-eye(nStates-numSmallestToPrevent))*(1-rho)./(nStates-1-numSmallestToPrevent);
    
    transitionProbsSingleStep(1:numSmallestToPrevent, numSmallestToPrevent+1:end) = ...
        ones([numSmallestToPrevent nStates-numSmallestToPrevent]) .* 1/nPossibleStates;
    
else
    
    transitionProbsSingleStep = zeros(nStates);
    for i=1:nStates
        if i==transPars.home
            transitionProbsSingleStep(i,:) = (1-transPars.rho0)/(nStates-1);
            transitionProbsSingleStep(i,i) = transPars.rho0;
        else
            transitionProbsSingleStep(i,:) = (1-transPars.rho)*(1-transPars.a)./(nStates-2);
            transitionProbsSingleStep(i,transPars.home) = (1-transPars.rho)*transPars.a;
            transitionProbsSingleStep(i,i) = transPars.rho;
        end
    end    
end

distanceList = ...
    unique([snpPositions(1)-1 ...
    snpPositions(2:end)-snpPositions(1:end-1) ...
    totalSequenceLength-snpPositions(end)]);

distanceList = setdiff(distanceList, 0);  % May happen if either the first or the last position is a SNP.
% 
% transMatrixArray = zeros(nStates,nStates,length(distanceList));
% distToIndexMapping = -1.*ones(1,max(distanceList));
% for distIndex = 1:length(distanceList)
%     transMatrixArray(:,:,distIndex) = transitionProbsSingleStep^distanceList(distIndex);
%     distToIndexMapping(distanceList(distIndex)) = distIndex;
% end
% preCalculatedTransMatrices.transMatrixArray = transMatrixArray;
% preCalculatedTransMatrices.distToIndexMapping = distToIndexMapping;

preCalculatedTransMatrices = cell(1,max(distanceList));
for dist = distanceList
   preCalculatedTransMatrices{dist} = transitionProbsSingleStep^dist;
end
