function uData = lineageSimilaritiesToLineageStructure(uData, type)
% type == 1, formulate lineageStructure
% type == 2, formulate clusterStructure

% Largest lineage has the largest index
% Always join a lineage to the largest lineage that it is similar with.

if type == 1
    partition = uData.groupedPartition;
    outputFilePrefix = 'lineage_';
elseif type == 2
    partition = uData.partition;
    outputFilePrefix = 'cluster_';
end

load([uData.outputDir uData.delimiter outputFilePrefix 'comparison.mat']); % allPairwiseMarginals

nLineages = max(partition);

nSnps = length(uData.snpPositions);
lineageStructure = zeros(nLineages, nSnps);


for lineageIndex = 1:1:nLineages-1
    
    lineageStructure(lineageIndex,:) = lineageIndex;
    
    for lineageWithWhichToJoin = nLineages : -1 : lineageIndex + 1
        
        %load([uData.outputDir uData.delimiter outputFilePrefix num2str(lineageIndex) '_' num2str(lineageWithWhichToJoin)]);
        % marginals, logPosterior
        marginals = allPairwiseMarginals{lineageIndex, lineageWithWhichToJoin};
        
        isSame = marginals(1,:) > 0.5;
        
        % Join sites which are same and which have not yet been joined with
        % a larger lineage.
        sitesToJoin = find(isSame & lineageStructure(lineageIndex,:) == lineageIndex);
        
        lineageStructure(lineageIndex, sitesToJoin) = lineageWithWhichToJoin;
        
    end
    
end

lineageStructure(nLineages,:) = nLineages;
if type == 1
    uData.lineageStructure = lineageStructure;
elseif type == 2
    uData.clusterStructure = lineageStructure;
end
