function transPars = learnTransPars(segmentsForStrains, totalSequenceLength, transPars)

y3 = 0;  % sum(lengths-1), lengths of home cluster segments.
y4 = 0;  % num of those home cluster segments after which comes another segment
y5 = 0;  % sum(lengths-1), lengths of recombinogenic segments.
y6 = 0;  % num of those non-home cluster segments after which comes home cluster segment
y7 = 0;  % num of those non-home cluster segments after which comes another non-home segment
for i=1:length(segmentsForStrains)
    segments = segmentsForStrains{i};   % columns: [start end origin]
    homeSegments = segments(segments(:,3)==transPars.home,:);
    y3 = y3 + sum(homeSegments(:,2)-homeSegments(:,1));
    y4 = y4 + length(find(homeSegments(:,2)<totalSequenceLength));
    
    recSegments = segments(segments(:,3)~=transPars.home,:);
    if ~isempty(recSegments)
        y5 = y5 + sum(recSegments(:,2)-recSegments(:,1));
    
        nextSegmentOrigin = [segments(2:end,3); 0];   % i:th element is the origin of i+1:th segment.
        y6 = y6 + length(find(segments(:,3)~=transPars.home & nextSegmentOrigin==transPars.home));
        y7 = y7 + length(find(segments(:,3)~=transPars.home & nextSegmentOrigin~=transPars.home & nextSegmentOrigin>0));
    end
end

%if y4<1
    transPars.rho0 = 0.5^(1/(totalSequenceLength-1)); % This is kept fixed in fastGEAR.
%else
%    transPars.rho0 = (y3+totalSequenceLength-2)/(y4+y3+totalSequenceLength-2);
%end

if y6+y7<=2
    meanTractLength = (transPars.muMax+transPars.muMin)/2;
    transPars.rho = (meanTractLength-1)/meanTractLength;
else
    transPars.rho = y5/(y5+y6+y7-2);
end

transPars.a = (y6+transPars.aPriorCount-1)/(y6+y7+transPars.aPriorCount ...
    +transPars.negAPriorCount-2);