function rho = learnRho(segmentsForStrains,totalSequenceLength)
% This function finds the MAP value for the rho parameter. This parameter
% specifies how likely it is for a strain to escape the current state.
%
% "segmentsForStrains" is a 1*nStrains cell array, where the i:th cell 
% contains "segments" for the i:th strain. "segments" is an nSegments*3
% array, where the first and second columns specify the starting and end
% positions of a segment and the last column is the origin of the segment.

y1 = 0;
y2 = 0;
for i=1:length(segmentsForStrains)
    segments = segmentsForStrains{i};
    y1 = y1 + sum(segments(:,2)-segments(:,1));
    y2 = y2 + size(segments,1)-1;
end

rho = (totalSequenceLength-2+y1)/(totalSequenceLength-2+y1+y2);