function popStructure = derivePopStructureFromLineageStructure(uData, type)
    % type == 2: lineage-level (lineageStructureCleaned)
    % type == 3 cluster-level (clusterStructureCleaned)
    % type == 4 lineage-level, not cleaned (lineageStructure)
    % type == 5 cluster-level, not cleaned (clusterStructure)
    
    if type == 2
        structure = uData.lineageStructureCleaned;
        partition = uData.groupedPartition;
        
    elseif type == 3
        structure = uData.clusterStructureCleaned;
        partition = uData.partition;
        
    elseif type == 4
        structure = uData.lineageStructure;
        partition = uData.groupedPartition;
        
    elseif type == 5
        structure = uData.clusterStructure;
        partition = uData.partition;
        
    end
    
    ninds = length(unique(partition));
    nSnps = length(uData.snpPositions);
    popStructure = zeros(ninds, nSnps, 'uint8');
    nComponents = size(structure,1);
    
    for componentIndex = 1:nComponents
        
        strainIds = find(partition == componentIndex);
        mergedAssignments = uint8(structure(componentIndex,:));
        popStructure(strainIds, :) = repmat(mergedAssignments, length(strainIds), 1); 
        
    end
end