function transitionProbs = calcTransitionProbs(snpDistance, preCalculatedTransMatrices)
% "snpDistance" is the distance of SNPs in the genome sequence.
%
% "totalSequenceLength" is the total length of the genome sequence.
%
% "nStates" is the number of possible states.
%
% "transitionProbs" is the transition matrix for changing state when we 
% move along the sequence over an interval of length "snpDistance".

% USAGE EXAMPLE:
% probOfNoChangesInSequence = 0.5;
% nStates = 6;
% totalSequenceLength = 3000000;
% snpDistance = 10000;
% transitionProbs = calcTransitionProbs(snpDistance, totalSequenceLength, nStates, probOfNoChangesInSequence)

%aux = dec2bin(snpDistance);
%aux = aux(end:-1:1);
%powers = find(aux=='1');

transitionProbs = preCalculatedTransMatrices{snpDistance}; % USED IN FINAL
%VERSION CURRENTLY 18.11.2015
%transitionProbs = preCalculatedTransMatrices.transMatrixArray(:,:,preCalculatedTransMatrices.distToIndexMapping(snpDistance));



%transitionProbs = preCalculatedTransMatrices(:,:,1)^snpDistance;   % THIS IS BEST SO FAR...

%transitionProbs = preCalculatedTransMatrices(:,:,powers(1))^snpDistance;
%for i=2:length(powers)
%    transitionProbs = transitionProbs*preCalculatedTransMatrices(:,:,powers(i));
%end