function writePartition(inputFile, outputFile)

load(inputFile); % Loads variable uData
partition = uData.partition;
groupedPartition = uData.groupedPartition;
strainLabels = uData.strainLabels;
writePartitionToFile(outputFile,partition, groupedPartition, strainLabels);


function writePartitionToFile(fName, partition, groupedPartition,strainLabels)
% The function writes the order of strains in the dendrogram.
outputId = fopen(fName,'w');
row = 'StrainIndex  Lineage  Cluster  Name';
fprintf(outputId, '%s\n',row);

nStrains = length(partition);
for strainIndex=1:nStrains
    clusterIndex = partition(strainIndex);
    lineageIndex = groupedPartition(strainIndex);
    fprintf(outputId,['%-13.0f%-9.0f%-9.0f' strainLabels{strainIndex} '\n'], strainIndex, lineageIndex, clusterIndex);
end
fclose(outputId);