#ifndef MATHUTIL_H
#define MATHUTIL_H

#include "defines.h"
#include <math.h>

class mathutil {
	public:
		mathutil(uint32_t N);

		double choose(uint32_t n, uint32_t  k) const {return m_fact[n] - m_fact[k] - m_fact[n - k];}
		double fact(uint32_t n) const {return m_fact[n];}
		double stirling(uint32_t n, uint32_t  k) const;

		double intcode(uint32_t n) const;

	protected:
		doublevector m_fact;
};

extern const double logbase;
#define lg2(x) (log(x) / logbase)

double score(uint32_t ones, uint32_t size, uint32_t baseones, uint32_t basesize);
double score(uint32_t ones, uint32_t size);

#endif
