#ifndef TILE_H
#define TILE_H


#include "defines.h"
#include "dataset.h"
#include "scanner.h"
#include <string>
#include <stdio.h>


struct tile {
	uint32_t id;

	uint32_t istart, iend;
	uint32_t tstart, tend;
	uint32_t ones;
	uint32_t size;

	double gain;

	double freq() const {return size > 0 ? double(ones) / size : 0;}

	void print(FILE *f);


	tile *parent;
};

typedef std::list<tile *> tilelist;


class tileset {
	public:
		tileset(const dataset & d, bool dis);
		~tileset();

		double optimize() {return optimize(m_tiles.front());}

		void print(FILE *f);


	protected:

		uint32_t & occupy(uint32_t t, uint32_t i) {return m_occupy[t * m_data.dim() + i];}
		uint32_t occupy(uint32_t t, uint32_t i) const {return m_occupy[t * m_data.dim() + i];}

		scanner::result optimize(const uintvector & p, const uintvector & n, uint32_t width, uint32_t baseones, uint32_t basesize) const;
		scanner::result optimize(const uintvector & p, const uintvector & n, uint32_t begin, uint32_t end, uint32_t baseones, uint32_t basesize) const;

		tile * find(const tile *cur) const;
		double optimize(tile *t);

		void add(tile *t, tile *parent);

		double tilecost(const tile *t, const tile *parent) const;
		double tileoverhead(const tile *base) const;

		tilelist m_tiles;
		const dataset & m_data;
		uintvector m_occupy;
		mutable scanner m_scanner;
		bool m_disjoint;

		std::string m_indent;
};


void print(const tilelist & tl);




#endif
