#include "scanner.h"
#include "dataset.h"
#include "tile.h"
#include "mathutil.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>





void
outofmemory()
{
	fprintf(stderr, "Oh noes! out of memory\n");
	exit(1);
}






int
main(int argc, char ** argv)
{
	static struct option longopts[] = {
		{"out",             required_argument,  NULL, 'o'},
		{"in",              required_argument,  NULL, 'i'},
		{"disjoint",        no_argument,        NULL, 'd'},
		{"help",            no_argument,        NULL, 'h'},
		{ NULL,             0,                  NULL,  0 }
	};

	const char *inname = NULL;
	const char *outname = NULL;
	bool disjoint = false;

	std::set_new_handler(outofmemory);

	int ch;
	while ((ch = getopt_long(argc, argv, "o:i:hd", longopts, NULL)) != -1) {
		switch (ch) {
			case 'h':
				printf("Usage: %s -i <input file> -o <output file> [options]\n", argv[0]);
				printf("  -h    print this help\n");
				printf("  -d    force tiles to be disjoint\n");
				printf("  -i    input file\n");
				printf("  -o    output file\n");

				return 0;
				break;
			case 'i':
				inname = optarg;
				break;
			case 'o':
				outname = optarg;
				break;
			case 'd':
				disjoint = true;
				break;
		}
	}


	if (inname == NULL) {
		fprintf(stderr, "Missing input file\n");
		return 1;
	}
	
	if (outname == NULL) {
		fprintf(stderr, "Missing output file\n");
		return 1;
	}

	FILE *f = fopen(inname, "r");
	dataset d;
	d.read_file(f);
	fclose(f);

	tileset ts(d, disjoint);
	double g = ts.optimize();
	double b = score(d.ones(), d.dim() * d.cnt());
	printf("Gain: %f %f\n", g, score(d.ones(), d.dim() * d.cnt()));

	f = fopen(outname, "w");
	fprintf(f, "%f %f %f\n", b, b - g, g);
	ts.print(f);
	fclose(f);

	return 0;
}
