#ifndef SCANNER_H
#define SCANNER_H

#include "defines.h"

class scanner {
	public:
		scanner(uint32_t N) : m_entries(N), m_max(N) {} //, debug(false) {}

		struct result {
			uint32_t start, end; 
			uint32_t ones, size; 
			double score;
		};

		result optimize(const uintvector & p, const uintvector & n, uint32_t s, uint32_t e, uint32_t baseones, uint32_t basesize);

		//bool debug;


	protected:

		void computemax(const uintvector & p, const uintvector & n, uint32_t s, uint32_t e);

		struct block {
			void set(uint32_t o, uint32_t s, uint32_t ind) {size = s; ones = o; index = ind;}
			void add(const block & t) {size += t.size; ones += t.ones;}

			uint32_t size, ones;
			uint32_t index;
			double freq() const {return size > 0 ? double(ones) / size : 0;}
		};

		struct entry {
			block t, u;
			entry *next;
		};

		typedef std::vector<entry> entryvector;
		typedef std::vector<block> blockvector;

		entryvector m_entries;
		blockvector m_max;
};

#endif
