#ifndef DATASET_H
#define DATASET_H

#include <stdint.h>
#include <stdio.h>

#include "queue.h"
#include "defines.h"

#include <vector>
#include <assert.h>


typedef std::set<uint32_t> idset;




class dataset {
	public:
		dataset() : m_dim(0), m_cnt(0), m_density(0) {TAILQ_INIT(&m_points);} 

		void read_file(FILE *f);


		uint32_t dim() const {return m_dim;}
		uint32_t cnt() const {return m_cnt;}
		uint32_t ones() const {return m_density;}


		uint32_t query(const uintvector & items) const;


		struct transaction {
			TAILQ_ENTRY(transaction) entries;
			uint32_t id;
		};

		TAILQ_HEAD(transhead, transaction);



		struct entry {
			transaction *t;
			TAILQ_ENTRY(entry) entries;
			entry *next() {return TAILQ_NEXT(this, entries);}
			const entry *next() const {return TAILQ_NEXT(this, entries);}
			uint32_t tid() const {return t->id;}
		};


		TAILQ_HEAD(entryhead, entry);

		const entry * first(uint32_t i) const {return TAILQ_FIRST(&m_ones[i]);}
	protected:


		uint32_t read_entry(FILE *f, uint32_t & linecnt, bool & eof, bool & digit);



		transhead m_points;
		std::vector<entryhead> m_ones;
		
		std::vector<entry> m_entries;
		std::vector<transaction> m_data;

		uint32_t m_dim, m_cnt, m_density;

		class query_elem {
			public:
				void init(const entryhead *eh) {m_e = TAILQ_FIRST(eh);}
				void advance() {assert(m_e); m_e = TAILQ_NEXT(m_e, entries);}

				bool end() const {return m_e == NULL;}

				uint32_t value() const {return m_e->t->id;}

				bool operator < (const query_elem &q) const {return m_e->t->id > q.m_e->t->id;}
			protected:
				const entry *m_e;
		};
};



#endif
