#include "dataset.h"
#include <math.h>
#include <ctype.h>

#include <stdexcept>
#include <algorithm>





uint32_t
dataset::read_entry(FILE *f, uint32_t & linecnt, bool & eof, bool & digit)
{
	linecnt = 0;
	eof = false;
	digit = false;

	while (true) {
		int c = fgetc(f);

		if (c == '\n')
			linecnt++;
		else if (isspace(c));
		else if (c == EOF) {
			eof = true;
			return 0;
		}
		else {
			ungetc(c, f);
			break;
		}
	}

	digit = true;
	uint32_t d = 0;
	while (true) {
		int c = fgetc(f);
		if (c == EOF) {
			eof = true;
			return d;
		}
		else if (isdigit(c))
			d = d*10 + c - '0';
		else if (isspace(c)) {
			ungetc(c, f);
			break;
		}
		else	
			throw std::runtime_error("Datafile contains illegal characters");
	}


	return d;
}


void
dataset::read_file(FILE *f)
{
	bool eof, digit;
	uint32_t linecnt;

	do {
		uint32_t d = read_entry(f, linecnt, eof, digit);
		m_cnt += linecnt;
		if (digit) {
			m_density++;
			if (d+ 1 > m_dim) m_dim = d + 1;
		}

	} while(!eof);

	

	m_ones.resize(m_dim);
	for (uint32_t i = 0; i < m_dim; i++)
		TAILQ_INIT(&m_ones[i]);

	m_entries.resize(m_density);

	m_data.resize(m_cnt);

	for (uint32_t i = 0; i < m_cnt; i++) {
		TAILQ_INSERT_TAIL(&m_points, &m_data[i], entries);
		m_data[i].id = i;
	}

	rewind(f);

	uint32_t t = 0;
	uint32_t e = 0;
	do {
		uint32_t d = read_entry(f, linecnt, eof, digit);
		t += linecnt;
		if (digit) {
			entry *ent = &m_entries[e++];
			TAILQ_INSERT_TAIL(&m_ones[d], ent, entries);
			ent->t = &m_data[t];
		}

	} while(!eof);
}


uint32_t
dataset::query(const uintvector & items) const
{
	uint32_t max = 0;
	uint32_t cnt = 0;

	std::vector<query_elem> queries(items.size());

	for (uint32_t i = 0; i < items.size(); i++) {
		queries[i].init(&m_ones[items[i]]);
		if (queries[i].end()) return 0;
		if (queries[i].value() > max)
			max = queries[i].value();
	}

	std::make_heap(queries.begin(), queries.end());

	while (true) {
		std::pop_heap(queries.begin(), queries.end());
		query_elem &q = queries.back();

		if (q.value() == max) cnt++;
		q.advance();
		if (q.end()) return cnt;
		if (q.value() > max) max = q.value();
		std::push_heap(queries.begin(), queries.end());
	}
}
