#include "scanner.h"
#include "mathutil.h"
#include <limits>
#include <assert.h>
#include <stdio.h>


void
scanner::computemax(const uintvector & p, const uintvector & n, uint32_t s, uint32_t e)
{
	uint32_t cnt = 0;

	for (int32_t i = e - 1; i >= int32_t(s); i--) {
		m_entries[cnt].t.set(p[i], p[i] + n[i], i);
		cnt++;
		while (cnt >= 2 && m_entries[cnt - 2].t.freq() > m_entries[cnt - 1].t.freq()) {
			m_entries[cnt - 2].t.add(m_entries[cnt - 1].t);
			cnt--;
		}

		m_max[i] = m_entries[cnt - 1].t;
		//printf("(%d %f) ", i, m_max[i].freq());
	}
}

scanner::result
scanner::optimize(const uintvector & p, const uintvector & n, uint32_t s, uint32_t e, uint32_t baseones, uint32_t basesize)
{
	computemax(p, n, s, e);
	result best;
	best.score = std::numeric_limits<double>::max();

	uint32_t temp = 0;
	for (uint32_t i = s; i < e; i++) {
		temp += p[i];
	}
	assert(temp <= baseones);

	entry *active = 0;
	uint32_t cnt = 0;

	for (uint32_t i = s; i < e; i++) {
		m_entries[cnt].t.set(p[i], p[i] + n[i], i);
		m_entries[cnt].u = m_entries[cnt].t;
		m_entries[cnt].next = active;
		active = &m_entries[cnt];
		cnt++;

		while (cnt >= 2 && m_entries[cnt - 2].t.freq() > m_entries[cnt - 1].t.freq()) {
			m_entries[cnt - 2].t.add(m_entries[cnt - 1].t);
			//if (m_entries[cnt - 1].t.index == 91 && debug)
				//printf("bee\n");
			if (&m_entries[cnt - 1] == active) {
				active = m_entries[cnt - 1].next;
				if (active) active->u.add(m_entries[cnt - 1].u);
			}
			cnt--;
		}

		double f = 0;
		if (i < e - 1) f = m_max[i + 1].freq();

		while (active) {
			// Check here
			block & b = active->u;


			/*if (baseones - b.ones  > basesize - b.size) {
				printf("%d %d %d %d\n", b.ones, b.size, baseones, basesize);
			}
			*/


			double c = score(b.ones, b.size, baseones, basesize);

			//if (i == 177 && debug)
				//printf("w %d %f %d %d %d %d %f\n", active->t.index, c, b.ones, b.size, baseones, active->t.ones, f);

			if (c < best.score) {
				best.score = c;
				best.start = active->t.index;
				best.end = i + 1;
				best.ones = b.ones;
				best.size = b.size;
			}

			entry *n = active->next;
			if (n && n->t.freq() > f) {
				assert(n->t.index < active->t.index);
				n->u.add(active->u);
				active = n;
			}
			else
				break;
		}

	}

	return best;
}
