import sys;
import operator;

class lattice:
	def __init__(self):
		self.children = {};
		self.obj = None;

	def add(self, key, obj):
		l = self;
		for x in key:
			if x in l.children:
				l = l.children[x];
			else:
				l.children[x] = lattice();
				l = l.children[x];
		l.obj = obj;	
		return l;

	def map(self, key, f, pos = 0):
		stack = [0] * (len(key) + 1);
		obj = [None] * (len(key) + 1);
		obj[0] = self;
		ind = 0;

		while ind >= 0:
			s = obj[ind];
			if s.obj != None:
				f(s.obj);

			pos = stack[ind];

			found = False;
			for i in range(pos, len(key)):
				if key[i] in s.children:
					stack[ind] = i + 1;
					stack[ind + 1] = i + 1;
					obj[ind + 1] = s.children[key[i]];
					ind += 1;
					found = True;
					break;

			if not found:	
				ind -= 1;
	

class itemset:
	def __init__(self, sets, sup):
		self.support = sup;
		self.sets = sets;
		self.supersets = [];
		self.e = 0;
		self.ind = [];


	def add(self, s):
		if (self != s):
			#print self.sets, s.sets;
			self.supersets.append(s);


		

	def compute(self):
		for s in self.supersets:
			s.e = 0;
		self.e = 1;

		for s in self.supersets:
			s.e -= self.e;
			if s.e != 0:
				for t in s.supersets:
					t.e -= s.e;

		cursup = self.support;
		cure = self.e;
		for s in self.supersets:
			if s.support == cursup:
				cure += s.e;
			else:
				if cure != 0:
					self.ind.append([self.support - cursup, cure]);
				cursup = s.support;	
				cure = s.e;
		if cure != 0:
			self.ind.append([self.support - cursup, cure]);

		#print self.sets, self.ind;

def compitemsets(self, other):
	N = min(len(self.ind), len(other.ind));
	for i in range(N):
		x = self.ind[i];
		y = other.ind[i];
		if x[0] < y[0]:
			return x[1];
		elif x[0] > y[0]:
			return -y[1];
		elif x[1] != y[1]:
			return x[1] - y[1];
	if N < len(self.ind):				
		return self.ind[N][1];
	elif N < len(other.ind):				
		return -other.ind[N][1];
	return 0;


f = open(sys.argv[1]);
lat = lattice();
itemsets = [];
K = 0;


for line in f:
	start = line.find('(');
	end = line.find(')');

	items = [int(x) for x in line[0:start].split()];
	items.sort();
	if len(items) > 0:
		K = max(K, items[-1]);

	support = int(line[(start + 1):end]);
	i = itemset(items, support);
	lat.add(items, i);
	itemsets.append(i);


	
#sort based on support 
itemsets.sort(key = operator.attrgetter('sets'), reverse = True);
itemsets.sort(key = operator.attrgetter('support'), reverse = True);


for i in itemsets:
	lat.map(i.sets, lambda x : x.add(i));

#possibly add full itemset
if len(itemsets[-1].sets) != K + 1:
	items = range(K + 1);
	i = itemset(items, 0);
	lat.add(items, i);
	lat.map(i.sets, lambda x : x.add(i));


for i in itemsets:
	i.compute();


#sort here
itemsets.sort(cmp = compitemsets, reverse = True);

lab = [str(x) for x in range(K + 1)];
if len(sys.argv) > 2:
	f = open(sys.argv[2]);
	lab = [x.strip() for x in f];

shift = 0;
if len(sys.argv) > 3:
	shift = int(sys.argv[3]);

for i in itemsets:
	if len(i.sets) > 0:
		print " ".join([lab[x - shift] for x in i.sets]),
	print "(%d)" % i.support

