#include "miner.h"
#include "measure.h"

miner::miner(const dataset & d, const params & p) : m_data(d), m_params(p), m_itemcnt(1)
{
	itemset *is = new itemset(uintvector(), m_data.cnt());
	// XXX Set robustness 
	m_lattice.set(is);
}


void
miner::test(const uintvector & items, latticelist & cands)
{
	latticevector parents;
	parents.reserve(items.size());

	if (!seq_tree::test(&m_lattice, items.begin(), items.end(), parents))
		return;

	// Support test
	uint32_t support = m_data.query(items);
	if (support < m_params.sup_threshold)
		return;

	itemset *is = new itemset(items, support);

	for (uint32_t i = 0; i < parents.size(); i++)
		is->set_parent(i, parents[i]->value());

	// robust tests
	uintvector cont = is->contingency();

	if (m_params.free.set) is->set_free(robustness_free(m_params.free.la, cont));
	if (m_params.ts.set) is->set_ts(robustness_ts(m_params.ts.la, cont));
	if (m_params.ndi.set) is->set_ndi(robustness_ndi(m_params.ndi.la, cont));

	if (is->free() < m_params.free.threshold || is->ts() < m_params.ts.threshold || is->ndi() < m_params.ndi.threshold) {
		delete is;
		return;
	}

	// Adding itemset
	cands.push_back(seq_tree::add(&m_lattice, items.begin(), items.end(), is));
	m_itemcnt++;
}

void
miner::expand(lattice *l, latticelist & cands)
{
	lattice *p = l->parent();
	itemset *a = l->value();

	uintvector items(a->items().size() + 1);
	std::copy(a->items().begin(), a->items().end(), items.begin());

	lattice::childmap::iterator it = l->location();
	for (++it; it != p->children().end(); ++it) {
		items.back() = it->second->value()->items().back();
		test(items, cands);
	}
}

void
miner::expand(const latticelist & cands, latticelist & out)
{
	for (latticelist::const_iterator it = cands.begin(); it != cands.end(); ++it)
		expand(*it, out);
}



void
miner::init(latticelist & cands)
{
	uintvector items(1);

	for (uint32_t i = 0; i < m_data.dim(); i++) {
		items[0] = i;
		test(items, cands);
	}
}


void
miner::mine()
{
	latticelist cands;
	init(cands);

	while (!cands.empty()) {
		latticelist out;
		expand(cands, out);
		cands.swap(out);
	}
}

struct collect {
	itemsetvector & v;
	uint32_t size;	

	void operator () (seq_tree::tree<uint32_t, itemset *> *l) {v[size++] = l->value();}
};

itemsetvector
miner::itemsets() 
{
	itemsetvector ret(m_itemcnt);
	collect c = {ret, 0};

	seq_tree::traverse(&m_lattice, c);

	return ret;
}

