#ifndef ITEMSET_H
#define ITEMSET_H

#include "defines.h"
#include <stdio.h>

class itemset;
typedef std::vector<itemset *> itemsetvector;

class itemset {
	public:
		itemset(const uintvector & items, uint32_t sup) : m_items(items), m_parents(items.size()), m_support(sup), m_free(1), m_ts(1), m_ndi(1) {}

		void set_parent(uint32_t i, itemset *p) {m_parents[i] = p;}
		void set_support(uint32_t v) {m_support = v;}
		void set_free(long double v) {m_free = v;}
		void set_ts(long double v) {m_ts = v;}
		void set_ndi(long double v) {m_ndi = v;}

		uint32_t support() const {return m_support;}
		long double free() const {return m_free;}
		long double ts() const {return m_ts;}
		long double ndi() const {return m_ndi;}

		const uintvector & items() {return m_items;}

		uintvector contingency() const {uintvector v(1 << m_items.size()); fillsup(v); qie(v); return v;}

		void print(FILE *f, const char *format) const;

	protected:
		void qie(uintvector & v) const;

		void fillsup(uintvector & v)  const {fillsup(v, v.size() - 1, 0, 0);}
		void fillsup(uintvector & v, uint32_t index, uint32_t s, uint32_t d)  const;

		uintvector m_items;
		itemsetvector m_parents;
		uint32_t m_support;

		long double m_free, m_ts, m_ndi;
};


#endif
