/*	$id$	*/
#ifndef GRAPH_H
#define GRAPH_H

#include "defines.h"

#include <vector>
#include <list>
#include <stdio.h>
#include <stdint.h>
#include "queue.h"
#include <limits>
#include <assert.h>



const uint32_t invalid_index = std::numeric_limits<uint32_t>::max();


class graph {
	public:
	
		struct edge {
			edge() {in.target = out.target = 0; isess = false; isactive = false;}
			
			bool isess, isactive;
			struct {
				uint32_t target;
				TAILQ_ENTRY(edge) entries;
				TAILQ_ENTRY(edge) essential;
			} in, out;
		};

		TAILQ_HEAD(edgelist, edge);

		struct node {
			uint32_t index;

			struct {
				edgelist edges;
				edgelist essentials;
				uint32_t degree;
			} in, out;
		};

		TAILQ_HEAD(nodelist, node);



		void print(FILE *f, const graph & ref) const;
		void print(FILE *f) const {print(f, *this);}

		uint32_t nodecnt() const {return m_nodes.size();}
		uint32_t edgecnt() const {return m_edgecnt;}

		const graph::node & get_node(uint32_t ind) const {return m_nodes[ind];}
		//const edge & get_edge(uint32_t ind) const {return m_edges[ind];}

        void lower_degree(uint32_t n, intvector & degree, intlist & out) const;
		void init_degree(intvector & degree, intlist & out) const;

		intlist cycle(uint32_t n) const;




		void build_essentials();

		bool adjacent(uint32_t from, uint32_t to) const;
		bool essential(uint32_t from, uint32_t to) const;


		bool subset(const graph *g) const;


		graph(uint32_t nodecnt); // Create a fully connected graph

		void closure(const graph *ref = 0);
		void unbind_edge(uint32_t from, uint32_t to);
		void add_edge(uint32_t from, uint32_t to) {if (!m_edges[edge_index(from, to)].isactive) bind_edge(from, to);}

	protected:
		void bind_edge(uint32_t from, uint32_t to);
		void reset_edges();

		void findchildren(uint32_t n, boolvector & visited, const graph & g, bool count, boolvector & out) const;


		uint32_t edge_index(uint32_t from, uint32_t to) const {assert(from != to); return (nodecnt() - 1) * from + to - (to > from ? 1: 0);}

		std::vector<node> m_nodes;
		std::vector<edge> m_edges;

		uint32_t m_edgecnt;
};


#endif
