#ifndef EPISODE_H
#define EPISODE_H

#include "graph.h"
#include "queue.h"
#include "sequence.h"
#include "machine.h"
#include <vector>
#include <math.h>



class comparator;


class episode {
	public:
		episode(uint32_t id, const symbolvector & events);

		//bool subgraph(const boolvector & i1, const episode & ep, const boolvector & i2) const;
		//bool subgraph(const episode & ep) const;
		//intvector nodemap(const boolvector & i1, const episode & ep, const boolvector & i2) const;

		graph & edges() {return m_edges;}

		const graph & edges() const {return m_edges;}

		const symbolvector & events() const {return m_events;}

		//const intvector & inverse(uint32_t i) const {return m_inverse[i];}
		//uint32_t index(uint32_t i) const {return m_symbols[i].index;}

		void print(FILE *f) const;
		void print(FILE *f, const sequence & s) const;

		void set_id(uint32_t id) {m_id = id;}
		uint32_t id() const {return m_id;}

		struct node {
			node() : count(0) {};
			uint32_t count;
			intvector ecounts;
			intvector estates;
			bool mark;

			double stay;

			double mass;
		};
		
		struct edge {
			edge() : index(0) {};
			//uint32_t count;
			uint32_t index;
			//uint32_t state;

			double p;
		};

		typedef machine<symbol_t, node, edge> basicmachine;

		void support_count(const sequence & s);

		void build();


		void test(const sequence & s);
		void testind(const sequence & s);
		void testsuper(const episode *ep, const sequence & s);

		uint32_t machnodecnt() const {return m_machine.nodecnt();}
		uint32_t machedgecnt() const {return m_machine.edgecnt();}


	protected:
		void iterscale();
		double error(const sequence & s) const;
		double error() const;

		void buildstates(const boolvector & prefix);
		void buildstates();
		void buildstates(basicmachine::node *n, const basicmachine::node *ref);


		doublevector computeprob(const basicmachine::node *n) const;
		doublevector computeprob(const basicmachine::node *n, double alpha, double *diff) const;
		double cost(double alpha, double *diff) const;

		void computetarget();
		void initparameters();
		void updateparameters(double alpha, double *gradient);
		void computegradients(double *hessian, double *gradient) const;

		void settransitions();

		void computeexpectation(doublevector & p);
		void computemean(const sequence & s, double & mean, double & var);


		typedef std::map<intlist, basicmachine::node *> idmap;

		basicmachine::node * buildbasic(const intvector & degree, const intlist & sources, idmap & nodeids, boolvector & used);

		void compute_counts(const sequence & s);


		uint32_t m_id;

		symbolvector m_events;
		intvector m_indexmap; // maps nodes to a unique label index
		symbolvector m_indexlabel; // maps index to a label
		std::map<symbol_t, uint32_t> m_labelindex; // maps labels to indices

		graph m_edges;

		index_t m_support;


		basicmachine m_machine;
		basicmachine::node *m_source, *m_sink;

		std::vector<basicmachine::edgelist> m_transitions;

		doublevector m_probs;
		double m_trans[3];
		double m_part1, m_part2;
		uint32_t m_psize;


		intvector m_target;

		typedef std::list<boolvector> prefixlist;

		prefixlist m_prefixes;

		double m_rank;
		double m_indrank;
		double m_pred;
		double m_indpred;
};

typedef std::list<episode *> episodelist;
typedef std::vector<episode *> episodevector;

episodelist read(const sequence & s, const char *name);

#endif 
