#ifndef SEGMENT_H
#define SEGMENT_H

#include "border.h"
#include <stdint.h>
#include "graph.h"

class varrange {
	public:
		varrange(const blockvector & bv);

		double var(int32_t i, int32_t j) const {uint32_t c = count(i, j); if (c == 0) return 0; double m = mean(i, j); return mom(i, j) - m*m/c;}

		double mean(uint32_t i, uint32_t j) const {return m_means[j + 1] - m_means[i];}
		double mom(uint32_t i, uint32_t j) const {return m_vars[j + 1] - m_vars[i];}
		uint32_t count(uint32_t i, uint32_t j) const {return m_counts[j + 1] - m_counts[i];}

	protected:
		doublevector m_means;
		doublevector m_vars;
		uintvector m_counts;

};


class segment {
	public:
		segment(const blockvector & b, uint32_t K, double e) : m_blocks(b), m_segs(K), m_vr(b), m_eps(e) {}

		void run();
		void extract(uintvector & res) const;

		double score() const {return m_segs.back().score.back();}
		double score(uint32_t k) const {return m_segs[k].score.back();}

		uint32_t segcnt() const {return m_segs.size();}



	protected:
		struct segmentation {
		    uintvector seg;
		    uintvector ind;
			doublevector score;
		};

		typedef std::vector<segmentation> segvector;

		void step(const segmentation & prev, segmentation & res);
		void init();


		blockvector m_blocks;
		segvector m_segs;
		varrange m_vr;

		double m_eps;
};

void segment_exact(const blockvector & blocks, uint32_t K);
void segment_init(const blockvector & blocks, doublevector & out);


#endif
