#include "segment.h"

varrange::varrange(const blockvector & bv) : m_means(bv.size() + 1), m_vars(bv.size() + 1), m_counts(bv.size() + 1)
{
	for (uint32_t i = 0; i < bv.size(); i++) {
		m_means[i + 1] = m_means[i] + bv[i].s;
		m_vars[i + 1] = m_vars[i] + bv[i].var;
		m_counts[i + 1] = m_counts[i] + bv[i].size;
	}
}


void
segment::init() 
{
	double ls = -1;
	uint32_t N = m_blocks.size();

	segmentation & res = m_segs[0];
	res.seg.resize(N);
	res.score.resize(N);
	res.ind.resize(N);
	int32_t k = -1;

	for (uint32_t i = 0; i < N; i++) {
		double s = m_vr.var(0, i);
		res.score[i] = s;
		res.seg[i] = 0;
		if (s > (1 + m_eps)*ls) {
			k++;
			ls = s;
		}
		res.ind[k] = i;
	}
}

void
segment::step(const segmentation & prev, segmentation & res)
{
    uint32_t N = m_blocks.size();
    res.seg.resize(N);
    res.score.resize(N);
    res.ind.resize(N);
	int32_t k = -1;
	double ls = -1;

    for (uint32_t i = 0; i < N; i++) {
        double best = prev.score[i];
        uint32_t bestind = i;
        for (uint32_t j = 0; prev.ind[j] < i; j++) {
            double cand = m_vr.var(prev.ind[j] + 1, i) + prev.score[prev.ind[j]];
            if (cand < best) { bestind = prev.ind[j] + 1; best = cand;}
        }

		if (best > (1 + m_eps)*ls) {
			k++;
			ls = best;
		}

        res.seg[i] = bestind;
        res.score[i] = best;
		res.ind[k] = i;
    }
}

void
segment::run()
{
	init();
	for (uint32_t i = 1; i < m_segs.size(); i++) 
		step(m_segs[i - 1], m_segs[i]);
}

void
segment::extract(uintvector & res) const
{
	uintvector b(m_segs.size());

	b.back() = m_segs[0].seg.size();
	uint32_t k = b.back();

	for (uint32_t i = m_segs.size() - 1; i > 0 && k > 0; i--) {
		k = b[i - 1] = m_segs[i].seg[k - 1];
	}

	res.resize(1 + m_segs.size());
	k = 0;
	for (uint32_t i = 0, j = 0; i < b.size(); i++) {
		for (; j < b[i] ; j++) {
			k += m_blocks[j].cnt;
		}
		res[i + 1] = k;
	}
}

