#ifndef GRAPH_H
#define GRAPH_H

#include <stdint.h>
#include <stdio.h>
#include <vector>
#include <string>
#include <algorithm>

typedef std::vector<uint32_t> uintvector;
typedef std::vector<double> doublevector;


class graph {
	public:

		void readweighted(FILE *f);
		void read(FILE *f);

		void prwr(doublevector & out, double alpha, const uintvector & seed, uint32_t cnt = 100) const;

		uint32_t size() const {return m_nodes.size();}

		uint32_t nbhd(uint32_t n, uint32_t i) const {return m_nodes[n].edges[i];}
		double weight(uint32_t n, uint32_t i) const {return m_nodes[n].weights[i];}
		double wdeg(uint32_t n) const {return m_nodes[n].w;}
		double deg(uint32_t n) const {return m_nodes[n].w;}

		double findw(uint32_t n, uint32_t m) const {for (uint32_t i = 0; i < nbhdsize(n); i++) if (nbhd(n, i) == m) return m_nodes[n].weights[i]; return 0;}
		uint32_t nbhdsize(uint32_t n) const {return m_nodes[n].edges.size();}

		double preweight(uint32_t n) const {return m_nodes[n].prew;}
		double prevar(uint32_t n) const {return m_nodes[n].prevar;}
		double predeg(uint32_t n) const {return m_nodes[n].predeg;}

		void permute(const uintvector & p);

		void update_pre();
		void set_weights_normalized(const doublevector & w);
		void set_weights_sum(const doublevector & w);
		void set_weights_min(const doublevector & w);

		const std::string & label(uint32_t n) const {return m_nodes[n].label;}

		uint32_t minid() const {return m_minid;}

		void print_pre() const;

		uint32_t & nbhd(uint32_t n, uint32_t i) {return m_nodes[n].edges[i];}
		double & weight(uint32_t n, uint32_t i) {return m_nodes[n].weights[i];}
	protected:
		double & wdeg(uint32_t n) {return m_nodes[n].w;}
		double relevance(uint32_t n, uint32_t i) const {return m_nodes[n].relevance[i];}


		struct node {
			uintvector edges;
			doublevector weights;
			doublevector relevance;
			std::string label;
			double w;

			double prew;
			double prevar;
			uint32_t predeg;

			void swap(node & a) {a.edges.swap(edges); a.weights.swap(weights); std::swap(label, a.label);}
		};
		
		typedef std::vector<node> nodevector;


		uint32_t m_minid;
		nodevector m_nodes;
};



#endif
