#ifndef BORDER_H
#define BORDER_H

#include <stdint.h>
#include <vector>

struct block {
	double s;
	double size;
	double var;
	uint32_t cnt;

	double freq() const {return s / size;};

	bool operator <= (const block & a) const {return s * a.size <= a.s * size;}

	void operator += (const block & a) {s += a.s; size += a.size; cnt += a.cnt; var += a.var;}
};

typedef std::vector<block> blockvector;


template <class W, class S>
void
border(const W & w, const S & sizes, const W & v, blockvector & out)
{
	out.resize(w.size());
	uint32_t hs = 0;

	for (int32_t i = w.size() - 1; i >= 0; i--) {
		out[hs].s = w[i];
		out[hs].size = sizes[i];
		out[hs].var = v[i];
		out[hs].cnt = 1;
		hs++;

		while (hs > 1 && out[hs - 1] <= out[hs - 2]) {
			out[hs - 2] += out[hs - 1];
			hs--;
		}
	}
	out.resize(hs);
}

#endif
