function Text = readBook(filename)

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

fid = fopen(filename,'r');
i = 0;
Text = cell(1);

% Dump first line
fgetl(fid);

% Process other lines
while(~feof(fid))
    % Read line
    line = fgetl(fid);
    % Parse line
    splitstring = regexp(line,' ','split');
    word = splitstring{2};
    clean = word(2:end-1);
    if(~isempty(clean))
        i = i + 1;
        Text{i} = clean;
    end
end

err = fclose(fid);

if(err > 0)
    fprintf('%s\n',['Could not close file, error: ' num2str(err)]);
end

end