function H = plotFrequency(seqIndex,event,stepsize,windowsize,Symbols)
%Plot the frequency throughout a sequence for various windowsizes

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

n = length(seqIndex);
nevents = length(event);
H = cell(1,length(windowsize));

eventIndex = false(nevents,n-nevents+1);
for i = 1:nevents
    eventIndex(i,:) = seqIndex(i:n-nevents+i) == event(i);
end
index = all(eventIndex,1);

n = length(index);

for i = 1:length(windowsize)
    % Compute trace
    ws = windowsize(i);
    nsteps = n-ws+1;
    seq_i = zeros(1,nsteps);
    for j = 1:nsteps
        seq_i(j) = sum(index(j:j+ws-1))/ws;
    end
    
    % Plot trace
    if(length(Symbols) == 1)
        symb = Symbols{1};
    else
        symb = Symbols{i};
    end
    x = ceil(ws/2):n-floor(ws/2);
    y = seq_i;
    H{i} = plot(x(1:stepsize:end),y(1:stepsize:end),symb,'LineWidth',2);
end

end