% Script for analyzing infrawatch data

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

%% Clear workspace
clear;

%% Read data
x = importdata('Infrawatch/infrawatch-24h-10HZ.csv');

%% Experiment
% windowsizes = 2.^(0:17);
windowsizes = round(10*sqrt(2).^(0:29));
ncols = 1000;

k = 3;
nrep = 200;
samplesize = 60;
plusplus = true;

exprep = 1;

err = zeros(1,exprep);
ws = cell(1,exprep);

tic_total = tic;

for i = 1:exprep
    % Compute trace matrix    
    tic_i = tic;
    Trace = computeSmoothTraceSample(x, windowsizes, ncols);
    fprintf('%s\n',['Trace matrix ' num2str(i) ' computed in ' ...
        num2str(toc(tic_i)) ' seconds.']);

    % Compute Clara++ clustering
    tic_i = tic;
    [ws{1,i},err(1,i)] = clara(Trace,k,nrep,samplesize,plusplus);
    fprintf('%s\n',['k = ' num2str(k) ' clustering computed in ' ...
        num2str(toc(tic_i)) ' seconds.']);
end

fprintf('%s\n',['Experiment finished in ' num2str(toc(tic_total)) ...
    ' seconds.']);

clear n i word Trace tic_total tic_i;

%% Save error
save dami_infrawatch.mat windowsizes ncols k nrep samplesize plusplus ...
    err ws;