function index = findWord(word, Wordlist)
% use binary search to find word index

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

minindex = 1;
maxindex = length(Wordlist);

index = floor((minindex+maxindex)/2);
match = Wordlist{index};

while(~strcmp(word,match) && (maxindex-minindex) > 500)
    direction = false;
    charindex = 1;
    minwordlength = min(length(word),length(match));
    while(~direction)
        if(charindex > minwordlength)
            direction = true;
            if(length(word) < length(match))
                maxindex = index - 1;
            else
                minindex = index + 1;
            end
        elseif(word(charindex) == match(charindex))
            charindex = charindex + 1;
        elseif(word(charindex) < match(charindex))
            direction = true;
            maxindex = index - 1;
        else
            direction = true;
            minindex = index + 1;
        end
    end
    
    index = floor((minindex+maxindex)/2);
    match = Wordlist{index};        
end

if(~strcmp(word,match))
    index = minindex+find(strcmp(word,Wordlist(minindex:maxindex)))-1;
end

end