% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

%% X: binary sequence to be analyzed
% X = [0 0 0 , repmat([1 0 0 0 0 0], 1, 10)];

npoints = 100000;
p = 0.1;
c = 16;
[X,t1,t2] = simulateVariablerate(npoints,p,c);

%% Load data
load example.mat;

%% Plot both trends in data
plottrue = false;

win = [floor(npoints/c) floor(npoints/(4*c))];
n = numel(win);

cc = cubehelix(5,1.9,1.35,2,1);

h = figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 26 12],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

lm = 0.068;
rm = 0.015;
width = 1-lm-rm;
bm = 0.168;
tm = 0.04;
height = 1-bm-tm;

axes('Position',[lm bm width height],'FontSize',14.0);

R = 0;
cl = [3 4];
for i=1:n
    win_size = win(i);
    freqs = zeros(1,numel(X)-win_size+1);
    for j=1:numel(X)-win_size+1
        freqs(j) = sum(X(j:j+win_size-1))/win_size;
    end
    plot(win_size/2:(numel(X)-win_size/2),freqs,'color',cc(cl(i),:));
    hold on;
    R = max([R, freqs]);
end
xlim([0 length(X)]);
set(gca,'XTick',0:20000:100000);
ylim([0 0.20]);
set(gca,'YTick',0:0.1:0.2);
xlabel('Starting position in sequence S');
ylabel('Relative frequency');
if(plottrue)
    plot(p*(t1+t2),'k');
    legend(['Window length: ',num2str(win(1))],['Window length: ',num2str(win(2))],'True distribution','Location','NorthWest');
else
    legend(['Window length: ',num2str(win(1))],['Window length: ',num2str(win(2))],'Location','NorthWest');
end
legend('boxoff');
box off;
set(gca,'TickDir','out');

%% Plot solution
win = [10971 2836 925];
n = numel(win);

cc = cubehelix(5,1.9,1.35,2,1);

h = figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 26 12],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

lm = 0.068;
rm = 0.015;
width = 1-lm-rm;
bm = 0.168;
tm = 0.04;
height = 1-bm-tm;

axes('Position',[lm bm width height],'FontSize',14.0);

R = 0;
cl = [3 2 4];
for i=1:n
    win_size = win(i);
    freqs = zeros(1,numel(X)-win_size+1);
    for j=1:numel(X)-win_size+1
        freqs(j) = sum(X(j:j+win_size-1))/win_size;
    end
    plot(win_size/2:(numel(X)-win_size/2),freqs,'color',cc(cl(i),:));
    hold on;
    R = max([R, freqs]);
end
xlim([0 length(X)]);
set(gca,'XTick',0:20000:100000);
ylim([0 0.20]);
set(gca,'YTick',0:0.1:0.2);
xlabel('Starting position in X');
ylabel('Relative frequency');
legend(['Window length: ',num2str(win(1))],['Window length: ',num2str(win(2))],['Window length: ',num2str(win(3))],'Location','NorthWest');
legend('boxoff');
box off;
set(gca,'TickDir','out');