function Trace = computeHapaxRatioMatrixSample(index, windowsize, ...
    nsamples)
%compute frequency-window size matrix

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

% Init
seqlength = length(index);
nwindows = length(windowsize);
maxwindow = max(windowsize);
if(nsamples > seqlength-maxwindow+1)
    error('nsamples larger than the number of available positions');
end

Trace = zeros(nsamples, nwindows, 'single');

sampleindex = randperm(seqlength-maxwindow+1);
sampleindex = sampleindex(1:nsamples);

% Compute hapax count matrix
parfor i = 1:nsamples
    k = sampleindex(i);
    subsequence = index(k:k+maxwindow-1); %#ok<PFBNS>
    % Iterate over window size
    map = containers.Map('KeyType','int32','ValueType','int32');
    
    for j = 1:nwindows
        % Find new sequence part
        if(j == 1)
            toadd = subsequence(1:windowsize(j)); %#ok<PFBNS>
        else
            toadd = subsequence(windowsize(j-1)+1:windowsize(j));
        end
        % Add to map
        for k = 1:length(toadd)
            key = toadd(k);
            if(isKey(map,key))
                map(key) = map(key)+1;
            else
                map(key) = 1;
            end
        end
        % Count number of hapaxes
        count = 0;
        frequencies = values(map);
        for k = 1:length(frequencies)
            if(frequencies{k} == 1)
                count = count + 1;
            end
        end
        Trace(i,j) = count;
    end
end

% Normalize by window size
Div = repmat((windowsize)',1,nsamples);
Trace = Trace' ./ Div;

end