function Trace = computeFrequencyMatrixSampleCollection(Index, event, ...
    windowsize, nsamples)
%compute frequency-window size matrix from collection of sequences

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

% Init
maxwindow = max(windowsize);
nsequences = length(Index);

% Compute number of possible sampling locations for each sequence
nlocations = zeros(1,nsequences);

for i = 1:nsequences
    nlocations(i) = max(0,length(Index{i})-maxwindow-length(event)+2);
end

substitute = cumsum(nlocations);

% Randomly pick number of samples per sequence
numberofsamples = zeros(1,nsequences);

randnumbers = zeros(1,nsamples);
for i = 1:nsamples
    randnumbers(i) = randi(substitute(end));
end

numberofsamples(1) = sum(randnumbers <= substitute(1));
for i = 2:nsequences
    numberofsamples(i) = sum(randnumbers <= substitute(i) & ...
        randnumbers > substitute(i-1));
end

% Compute frequency-window size matrix per sequence
Trace = zeros(length(windowsize),nsamples,'single');

for i = 1:nsequences
    if(numberofsamples(i) > 0)
        if(i == 1 || sum(numberofsamples(1:i-1)) == 0)
            indexi = 1:numberofsamples(i);
        else
            indexi = sum(numberofsamples(1:i-1))+1:sum(numberofsamples(1:i));
        end
        Trace(:,indexi) = computeFrequencyMatrixSample(Index{i}, event, ...
            windowsize, numberofsamples(i));
    end
end

end