function Trace = computeFrequencyMatrixSample(index, event, ...
    windowsize, nsamples)
%compute frequency-window size matrix

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

% Init
seqlength = length(index);
nwindows = length(windowsize);
maxwindow = max(windowsize);
Trace = zeros(nsamples, nwindows , 'single');

sampleindex = randi(seqlength-maxwindow-length(event)+2,1,nsamples);

% Compute count matrix
parfor i = 1:nsamples
    k = sampleindex(i);
    indexpart = index(k:k+maxwindow+length(event)-2); %#ok<PFBNS>
    matchj = false(length(event),length(indexpart)-length(event)+1);
    for j = 1:length(event)
        matchj(j,:) = indexpart(j:length(indexpart)-length(event)+j)==event(j);
    end
    match = cumsum(all(matchj,1));
    % Iterate over window size
    Trace(i,:) = match(windowsize);
end

% Normalize by window size
Div = repmat((windowsize)',1,nsamples);
Trace = Trace' ./ Div;

end