function Collection = cleanDNASequence(sequence)
% Break sequence into known parts

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

index = strfind(sequence,'N');

consecutive = diff(index)==1;

nstart = index(~[0 consecutive]);
nend = index(~[consecutive 0]);

if(index(1) == 1)
    % First segment starts after initial N's
    segmentstart = nend+1;
    segmentend = [nstart(2:end)-1 length(sequence)];
else
    % First segment starts immediately
    segmentstart = [1 nend+1];
    segmentend = [nstart-1 length(sequence)];
end

if(index(end) == length(sequence))
    % Last segment ends before final N's
    segmentstart = segmentstart(1:end-1);
    segmentend = segmentend(1:end-1);
else
    % Last segment ends at sequence end
end

nsegments = length(segmentstart);
Collection = cell(nsegments,1);

for i = 1:nsegments
    Collection{i} = sequence(segmentstart(i):segmentend(i));
end

end