% Script for analyzing infrawatch data

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

%% Clear workspace
clear;

%% Load data and analysis
x = importdata('../Infrawatch/infrawatch-24h-10HZ.csv');

load dami_infrawatch.mat ws windowsizes;
ws = sort(windowsizes(ws{1}));

%% Plot sequence using all given scales
figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 26 20],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

lm = 0.063;
rm = 0.027;
width = 1-lm-rm;
bm = 0.090;
tm = 0.02;
cvm = 0.085;
height = (1-bm-tm-cvm)/2;

symbols = {'-g','-b','-r'};

% Part 1
axes('Position',[lm bm+height+cvm width height],'FontSize',14.0);
hold on;

H = plotMean(x,1,ws,symbols);

ylabel('Mean value');
xlim([1 length(x)]);
set(gca,'XTick',1:(length(x)-1)/6:length(x));
set(gca,'XTickLabel',{'00:00','04:00','08:00','12:00','16:00','20:00','24:00'});
ylim([0 35]);
l = legend([H{:}],{['Window length: ' num2str(ws(1))],...
    ['Window length: ' num2str(ws(2))],...
    ['Window length: ' num2str(ws(3))]},'Location','NorthWest');
set(l, 'Box', 'off');
box off;
set(gca,'TickDir','out');

% Part 2
axes('Position',[lm bm width height],'FontSize',14.0);
hold on;

H = plotMean(x,1,ws,symbols);

ylabel('Mean value');
xlabel('Time');
xlim([1+9*(length(x)-1)/24 1+10*(length(x)-1)/24]);
set(gca,'XTick',[1+9*(length(x)-1)/24:(length(x)-1)/96:1+10*(length(x)-1)/24]);
set(gca,'XTickLabel',{'09:00','09:15','09:30','09:45','10:00'});
ylim([0 35]);
l = legend([H{:}],{['Window length: ' num2str(ws(1))],...
    ['Window length: ' num2str(ws(2))],...
    ['Window length: ' num2str(ws(3))]},'Location','NorthWest');
set(l, 'Box', 'off');
box off;
set(gca,'TickDir','out');

clear i cvm lm rm width bm tm cvm height vpos ymax event symbols H l;