% Script for analyzing TTR distribution in various novels

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

%% Clear workspace
clear;

%% Load data
load dami_booksHLR.mat;

%% Plot optimal k = 3 window lengths for all books
figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 26 11],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

lm = 0.07;
rm = 0.015;
width = 1-lm-rm;
bm = 0.11;
tm = 0.045;
height = 1-bm-tm;

symb = 's^od';

axes('Position',[lm bm width height],'FontSize',14.0);
hold on;

data = sort(reshape([ws{:}],k,[]))';
h = cell(1,4);
% Data
h{1} = plot(1:100,data(1:100,:),[symb(1) 'b'],'MarkerSize',6);
h{2} = plot(106:205,data(101:200,:),[symb(2) 'b'],'MarkerSize',6);
h{3} = plot(211:310,data(201:300,:),[symb(3) 'b'],'MarkerSize',6);
h{4} = plot(316:415,data(301:400,:),[symb(4) 'b'],'MarkerSize',6);
% Averages
plot([1 100],[mean(data(1:100,:))' mean(data(1:100,:))'],'-r','LineWidth',2);
plot([106 205],[mean(data(101:200,:))' mean(data(101:200,:))'],'-r','LineWidth',2);
plot([211 310],[mean(data(201:300,:))' mean(data(201:300,:))'],'-r','LineWidth',2);
plot([316 415],[mean(data(301:400,:))' mean(data(301:400,:))'],'-r','LineWidth',2);

ylim([1 max(windowsizes)]);
xlim([0 416]);
ylabel('Window length');
set(gca,'XTick',[50.5 155.5 260.5 355.5]);
set(gca,'XTickLabel',{'Imaginative prose','Newspaper texts','Academic prose','Conversations'});
set(gca,'YScale','log');
set(gca,'TickDir','out');
box off;

clear lm rm width bm tm height;

%% Run ttest for all pairwise comparison for shortest window lenghts
pvalues1 = zeros(4,4);
pvalues2 = zeros(4,4);
pvalues3 = zeros(4,4);
for i = 1:4
    for j = 1:4
        pvalues1(i,j) = ranksum(data((1:100)+100*(i-1),1),data((1:100)+100*(j-1),1));
        pvalues2(i,j) = ranksum(data((1:100)+100*(i-1),2),data((1:100)+100*(j-1),2));
        pvalues3(i,j) = ranksum(data((1:100)+100*(i-1),3),data((1:100)+100*(j-1),3));
    end
end