function Trace = computeFrequencyMatrix(index, event, windowsize)
%compute frequency-window size matrix

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

% Init
seqlength = length(index);
nwindows = length(windowsize);
Trace = zeros(nwindows, seqlength, 'single');

positions = find(index == event);

% Compute count matrix
for i = positions
    % Iterate over window size
    parfor j = 1:nwindows
        % Since windows 'look ahead', occurrences are inserted 'backwards'
        trace_j = Trace(j,:);
        winpos = max(1,i-windowsize(j)+1):i;
        trace_j(1,winpos) = trace_j(1,winpos) + 1;
        Trace(j,:) = trace_j;
    end
end

% Normalize by window size
Div = repmat((windowsize)',1,seqlength);
Trace = Trace ./ Div;

% Throw away incomplete part
Trace = Trace(:,1:seqlength-max(windowsize)+1);

end