function error = computeError(data, windowsizes, chosen)
% Compute error for relative frequency statistic on full data for a set of
% chosen window sizes
% NB. data should be a binary vector

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

n_chosen = length(chosen);
n_windows = length(windowsizes);

sum_data = [0 cumsum(data)];

dist = zeros(n_windows,n_chosen);

trace = zeros(n_chosen,length(data)-max(windowsizes)+1);

% Compute vectors for chosen
parfor i = 1:n_chosen
    trace(i,:) = (sum_data(chosen(i)+1:end-max(windowsizes)+chosen(i)) - ...
        sum_data(1:end-max(windowsizes))) ./ chosen(i); %#ok<PFBNS>
end

parfor i = 1:n_windows
    trace_i = (sum_data(windowsizes(i)+1:end-max(windowsizes)+windowsizes(i)) - ...
        sum_data(1:end-max(windowsizes))) ./ windowsizes(i); %#ok<PFBNS>
    for j = 1:n_chosen
        dist(i,j) = sum((trace(j,:) - trace_i).^2); %#ok<PFBNS>
    end
end

error = sum(min(dist,[],2));

end