% Script for analyzing results from randomization experiments

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

%% Clear workspace
clear;

%% Plot optimal window lengths for experiment 1
figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 26 18],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

lm = 0.068;
rm = 0.01;
chm = 0.02;
width = (1-lm-rm-chm)/2;
bm = 0.095;
tm = 0.025;
cvm = 0.04;
height = (1-bm-tm-cvm)/2;

symb = 's^od';
ls = ':';
os = '--';

% Load analysis solution stability for one sequence
load dami_random1.mat;

for i = 1:4
    switch i
        case 1
            hpos = lm;
            vpos = bm+height+cvm;
        case 2
            hpos = lm+width+chm;
            vpos = bm+height+cvm;
        case 3
            hpos = lm;
            vpos = bm;
        case 4
            hpos = lm+width+chm;
            vpos = bm;
    end
    axes('Position',[hpos vpos width height],'FontSize',14.0,'TickDir','out');
    hold on;

    % Plot
    for j = 1:4
        for g = 1:4
            r = i;
            s = g;
            x = sort(sort(reshape([ws{:,j,r,s}],[],100),'descend'),2);
            
            cutmin = 1+floor(size(x,2)/20);
            cutmax = size(x,2)-floor(size(x,2)/20);
            mid = [ceil(size(x,2)/2) floor(1+size(x,2)/2)];

            for l = 1:size(x,1)
                offset = (2*g-6)*0.05;
                plot(j+offset,mean(x(l,mid)),symb(l),'MarkerSize',8);
                plot([j-.03 j+.03]+offset,[x(l,cutmax) x(l,cutmax)],'-');
                plot([j-.03 j+.03]+offset,[x(l,cutmin) x(l,cutmin)],'-');
                if(size(x,1) == 1)
                    plot([j j]+offset,[x(l,cutmin) x(l,cutmax)],ls);
                else
                    switch l
                        case 1
                            plot([j j]+offset,[max(x(l,cutmin), ...
                                x(l+1,cutmax)) x(l,cutmax)],ls);
                            if(x(l,cutmin) < x(l+1,cutmax))
                                plot([j j]+offset,[x(l,cutmin) ...
                                    x(l+1,cutmax)],os);
                            end
                        case size(x,1)
                            plot([j j]+offset,[x(j,cutmin) ...
                                min(x(j,cutmax),x(j-1,cutmin))],ls);
                        otherwise
                            plot([j j]+offset,[max(x(l,cutmin),...
                                x(l+1,cutmax)) min(x(l,cutmax),...
                                x(l-1,cutmin))],ls);
                            if(x(l,cutmin) < x(l+1,cutmax))
                                plot([j j]+offset,[x(l,cutmin) ...
                                    x(l+1,cutmax)],os);
                            end
                    end
                end
                if(j == 1)
                    text(j+offset,x(l,cutmin)*0.7,['Clara: r = ' num2str(nrep(r)) ...
                        ', s = ' num2str(samplesize(s))],...
                        'Rotation',90,'HorizontalAlignment','right');
                end
            end
        end
        x = sort(sort(reshape([wspam{:,j}],[],100),'descend'),2);
        for l = 1:size(x,1)
            offset = 4*0.05;
            plot(j+offset,mean(x(l,mid)),symb(l),'MarkerSize',8);
            plot([j-.03 j+.03]+offset,[x(l,cutmax) x(l,cutmax)],'-');
            plot([j-.03 j+.03]+offset,[x(l,cutmin) x(l,cutmin)],'-');
            if(size(x,1) == 1)
                plot([j j]+offset,[x(l,cutmin) x(l,cutmax)],ls);
            else
                switch l
                    case 1
                        plot([j j]+offset,[max(x(l,cutmin),...
                            x(l+1,cutmax)) x(l,cutmax)],ls);
                        if(x(l,cutmin) < x(l+1,cutmax))
                            plot([j j]+offset,[x(l,cutmin) ...
                                x(l+1,cutmax)],os);
                        end
                    case size(x,1)
                        plot([j j]+offset,[x(l,cutmin) min(x(l,cutmax), ...
                            x(l-1,cutmin))],ls);
                    otherwise
                        plot([j j]+offset,[max(x(l,cutmin),...
                            x(l+1,cutmax)) min(x(l,cutmax),...
                            x(l-1,cutmin))],ls);
                        if(x(l,cutmin) < x(l+1,cutmax))
                            plot([j j]+offset,[x(l,cutmin) ...
                                x(l+1,cutmax)],os);
                        end
                end
            end
            if(j == 1)
                text(j+offset,x(l,cutmin)*0.7,'PAM',...
                    'Rotation',90,'HorizontalAlignment','right');
            end
        end
    end
    xlim([0.6 4.4]);
    set(gca,'XTick',1:length(k));
    set(gca,'YScale','log');
    ylim([0.98 max(windowsizes)]);
    if(mod(i,2) == 1)
        ylabel('Window length');
    else
        set(gca,'YTickLabel',{});
    end
    if(i >= 3)
        xlabel('Number of window lengths');
        set(gca,'XTickLabel',k);
    else
        set(gca,'XTickLabel',{});
    end
    box off;
end

clear i j g l chm lm rm width bm tm height hpos vpos cutmin cutmax mid;

%% Clear workspace
clear;

%% Plot optimal window lengths for experiment 2
figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 13.7 10.9],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

lm = 0.135;
rm = 0.018;
width = 1-lm-rm;
bm = 0.182;
tm = 0.035;
height = 1-bm-tm;

symb = 's^od';
ls = ':';
os = '--';

% Load analysis solution stability for one sequence
load dami_random2.mat;

axes('Position',[lm bm width height],'FontSize',14.0);
hold on;

% Plot
for i = 1:4
    for j = 1:4
        x = sort(sort(reshape([ws{:,i}],[],100),'descend'),2);
        
        cutmin = 1+floor(size(x,2)/20);
        cutmax = size(x,2)-floor(size(x,2)/20);
        mid = [ceil(size(x,2)/2) floor(1+size(x,2)/2)];
        
        for l = 1:size(x,1)
            plot(i,mean(x(l,mid)),symb(l),'MarkerSize',8);
            plot([i-.03 i+.03],[x(l,cutmax) x(l,cutmax)],'-');
            plot([i-.03 i+.03],[x(l,cutmin) x(l,cutmin)],'-');
            if(size(x,1) == 1)
                plot([i i],[x(l,cutmin) x(l,cutmax)],ls);
            else
                switch l
                    case 1
                        plot([i i],[max(x(l,cutmin), ...
                            x(l+1,cutmax)) x(l,cutmax)],ls);
                        if(x(l,cutmin) < x(l+1,cutmax))
                            plot([i i],[x(l,cutmin) ...
                                x(l+1,cutmax)],os);
                        end
                    case size(x,1)
                        plot([i i],[x(l,cutmin) ...
                            min(x(l,cutmax),x(l-1,cutmin))],ls);
                    otherwise
                        plot([i i],[max(x(l,cutmin),...
                            x(l+1,cutmax)) min(x(l,cutmax),...
                            x(l-1,cutmin))],ls);
                        if(x(l,cutmin) < x(l+1,cutmax))
                            plot([i i],[x(l,cutmin) ...
                                x(l+1,cutmax)],os);
                        end
                end
            end
        end
    end
end
xlim([0.6 4.4]);
set(gca,'XTick',1:length(k));
set(gca,'XTickLabel',k);
xlabel('Number of window lengths');
set(gca,'YScale','log');
set(gca,'TickDir','out');
ylim([0.98 max(windowsizes)]);
box off;
ylabel('Window length');

clear lm rm width bm tm height col i j l mid cutmin cutmax;

%% Clear workspace
clear;

%% Plot solution for experiment 3
figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 26 10.9],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

lm = 0.085;
rm = 0.01;
width = 1-lm-rm;
bm = 0.185;
tm = 0.035;
height = 1-bm-tm;

symb = 's^od';
ls = ':';
os = '--';

axes('Position',[lm bm width height],'FontSize',14.0);
hold on;

% Load analysis variable rate
load dami_random3.mat ws ncols windowsizes;

% Plot
for i = 1:length(ncols)
    x = sort(sort(reshape([ws{i,:}],[],100),'descend'),2);
    
    cutmin = 1+floor(size(x,2)/20);
    cutmax = size(x,2)-floor(size(x,2)/20);
    mid = [ceil(size(x,2)/2) floor(1+size(x,2)/2)];
    
    for l = 1:size(x,1)
        plot(i,mean(x(l,mid)),symb(l),'MarkerSize',8);
        plot([i-.06 i+.06],[x(l,cutmax) x(l,cutmax)],'-');
        plot([i-.06 i+.06],[x(l,cutmin) x(l,cutmin)],'-');
        if(size(x,1) == 1)
            plot([i i],[x(l,cutmin) x(l,cutmax)],ls);
        else
            switch l
                case 1
                    plot([i i],[max(x(l,cutmin), ...
                        x(l+1,cutmax)) x(l,cutmax)],ls);
                    if(x(l,cutmin) < x(l+1,cutmax))
                        plot([i i],[x(l,cutmin) ...
                            x(l+1,cutmax)],os);
                    end
                case size(x,1)
                    plot([i i],[x(l,cutmin) ...
                        min(x(l,cutmax),x(l-1,cutmin))],ls);
                otherwise
                    plot([i i],[max(x(l,cutmin),...
                        x(l+1,cutmax)) min(x(l,cutmax),...
                        x(l-1,cutmin))],ls);
                    if(x(l,cutmin) < x(l+1,cutmax))
                        plot([i i],[x(l,cutmin) ...
                            x(l+1,cutmax)],os);
                    end
            end
        end
    end
end
set(gca,'XTick',1:length(ncols));
set(gca,'XTickLabel',ncols);
xlim([0.6 length(ncols)+0.4]);
xlabel('Number of samples');
set(gca,'YTick',0:length(windowsizes)/5:length(windowsizes));
ylim([0 max(windowsizes)]);
ylabel('Window length');
set(gca,'TickDir','out');
box off;

clear lm rm width bm tm height col i x j;

%% Clear workspace
clear;

%% Plot solution for Experiment 4
load example.mat X X_permuted npoints c;
load dami_random4.mat ws ws_perm windowsizes;

% Init
win = sort(ws{1},'descend');
n = numel(win);
cc=hsv(30);

lm = 0.068;
rm = 0.015;
width = 1-lm-rm;
bm = 0.17;
tm = 0.04;
height = 1-bm-tm;

% Draw
figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 26 12],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

axes('Position',[lm bm width height],'FontSize',14.0);

R = 0;
cl = [1 21 10];
for i = 1:n
    win_size = win(i);
    num_points = numel(X)-win_size+1;
    freqs = zeros(1,num_points);
    for j = 1:num_points
        freqs(j) = sum(X(j:j+win_size-1)) / win_size;
    end
    plot(win_size/2:(numel(X)-win_size/2),freqs,'color',cc(cl(i),:));
    hold on;
    R = max([R, freqs]);
end
xlim([0 length(X)]);
set(gca,'XTick',0:20000:100000);
ylim([0 0.20]);
set(gca,'YTick',0:0.1:0.2);
xlabel('Starting position in X');
ylabel('Relative frequency');
legend(['Window length: ' num2str(win(1))],['Window length: ' ...
    num2str(win(2))],['Window length: ' num2str(win(3))],...
    'Location','NorthWest');
legend('boxoff');
set(gca,'TickDir','out');
box off;

clear win n cc lm rm width bm tm height h R cl i j win_size num_points freqs;

%% Compute error for both data sequences using both sets of window lengths
load example.mat X X_permuted npoints c;
load dami_random4.mat ws ws_perm windowsizes;

Error = zeros(2,2);

Error(1,1) = computeError(X, windowsizes, ws{1});
Error(1,2) = computeError(X_permuted, windowsizes, ws{1});
Error(2,1) = computeError(X, windowsizes, ws_perm{1});
Error(2,2) = computeError(X_permuted, windowsizes, ws_perm{1});