% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

%% Clear workspace
clear;

%% Load results
load dami_hs.mat ws windowsizes k events;

hs_ws = ws;

load dami_cf.mat ws;

cf_ws = ws;

clear ws;

%% Plot optimal k = 3 window lengths for both chromosomes
figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 26 12],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

lm = 0.07;
rm = 0.015;
width = 1-lm-rm;
bm = 0.16;
tm = 0.04;
height = 1-bm-tm;

symb = 's^o';
ls = ':';
os = '--';

axes('Position',[lm bm width height],'FontSize',14.0,'TickDir','out');
hold on;

for i = 1:12
    if(i <= 6)
        data = sort(sort(reshape([hs_ws{i,:}],k,[]),'descend'),2);
    else
        data = sort(sort(reshape([cf_ws{i-6,:}],k,[]),'descend'),2);
    end
    
    cutmin = 1+floor(size(data,2)/20);
    cutmax = size(data,2)-floor(size(data,2)/20);
    mid = [floor(size(data,2)/2) ceil(size(data,2)/2)];
    
    for j = 1:k
        plot(i,mean(data(j,mid)),symb(j),'MarkerSize',8);
        plot([i-.05 i+.05],[data(j,cutmin) data(j,cutmin)],'-');
        plot([i-.05 i+.05],[data(j,cutmax) data(j,cutmax)],'-');
        switch j
            case 1
                plot([i i],[max(data(j,cutmin),data(j+1,cutmax)) ...
                    data(j,cutmax)],ls);
                if(data(j,cutmin) < data(j+1,cutmax))
                    plot([i i],[data(j,cutmin) data(j+1,cutmax)],os);
                end
            case k
                plot([i i],[data(j,cutmin) min(data(j,cutmax), ...
                    data(j-1,cutmin))],ls);
            otherwise
                plot([i i],[max(data(j,cutmin),data(j+1,cutmax)) ...
                    min(data(j,cutmax),data(j-1,cutmin))],...
                    ls);
                if(data(j,cutmin) < data(j+1,cutmax))
                    plot([i i],[data(j,cutmin) data(j+1,cutmax)],...
                        os);
                end
        end
    end
end

set(gca,'YScale','log');
set(gca,'XTick',1:12);
set(gca,'XTickLabel',{'A','C','G','T','TA','CG','A','C','G','T','TA','CG'});
ylim([100 max(windowsizes)]);
xlim([0.4 12.6]);
box on;
ylabel('Window length');
text(3.5,50,'Homo Sapiens','FontSize',16,'HorizontalAlignment','center');
text(9.5,50,'Canis Familiaris','FontSize',16,'HorizontalAlignment','center');

clear lm rm width bm tm height symb index i data j cutmin cutmax mid;
clear symb ls os;

%% Load sequences for visualization
load hs_seq.mat Index;
HS = [Index{:}];
load cf_seq.mat Index;
CF = [Index{:}];

clear Index;

%% Plot CG in both sequences
figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 26 20],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

lm = 0.07;
rm = 0.015;
width = 1-lm-rm;
bm = 0.095;
tm = 0.025;
cvm = 0.10;
height = (1-bm-tm-cvm)/2;

ymax = 0.2;
event = [2 3];
symbols = {':.b',':.r',':.g'};

for i = 1:2
    vpos = bm+(2-i)*(height+cvm);
    axes('Position',[lm vpos width height],'FontSize',14.0);
    hold on;
    
    if(i == 1)
        ws = sort(sort(reshape([hs_ws{6,:}],3,[])),2);
        H = plotFrequency(HS(1:220000),event,1,ws(:,25),symbols);
        text(100000,ymax*0.93,'Homo Sapiens chromosome 1',...
            'FontSize',16,'HorizontalAlignment','center');
    else
        ws = sort(sort(reshape([cf_ws{6,:}],3,[])),2);
        H = plotFrequency(CF(1:220000),event,1,ws(:,25),symbols);
        text(100000,ymax*0.93,'Canis Familiaris chromosome 1',...
            'FontSize',16,'HorizontalAlignment','center');
        xlabel('Sequence index');
    end
    l = legend([H{:}],{['Window length: ' num2str(ws(1,25))],...
        ['Window length: ' num2str(ws(2,25))],...
        ['Window length: ' num2str(ws(3,25))]});
    ylabel('Frequency of CG');
    ylim([0 ymax]);
    xlim([0 200000]);
    set(gca,'YTick',0:0.1:ymax);
    set(gca,'TickDir','out');
    box on;
    set(l, 'Box', 'off');
end

clear i cvm lm rm width bm tm cvm height vpos ymax event symbols ws H l;

%% Plot A C G T TA and CG in Homo Sapiens
figure('Name','Word frequency histograms','Units','centimeters',...
    'OuterPosition',[3 3 26 36],'Resize','off',...
    'PaperOrientation','landscape','PaperType','A4','Renderer','painters');

lm = 0.07;
rm = 0.015;
width = 1-lm-rm;
bm = 0.05;
tm = 0.01;
cvm = 0.05;
height = (1-bm-tm-cvm*5)/6;

ymax = 1.0;
event = {1,2,3,4,[4 1],[2 3]};
eventname = {'A','C','G','T','TA','CG'};
symbols = {'-b','-r','-g'};
stepsize = 20;

for i = 1:6
    vpos = bm+(6-i)*(height+cvm);
    axes('Position',[lm vpos width height],'FontSize',14.0);
    hold on;
    
    ws = sort(sort(reshape([hs_ws{i,:}],k,[])),2);
    H = plotFrequency(HS(1:220000),event{i},stepsize,ws(:,25),symbols);
    l = legend([H{:}],{['Window length: ' num2str(ws(1,25))],...
        ['Window length: ' num2str(ws(2,25))],...
        ['Window length: ' num2str(ws(3,25))]});
    ylabel('Relative frequency');
    if(i <= 4)
        ylim([0 ymax]);
        text(2000,ymax*0.88,eventname{i},'FontSize',16);
        set(gca,'YTick',0:0.2:ymax);
    else
        ylim([0 0.4]);
        text(2000,0.4*0.88,eventname{i},'FontSize',16);
        set(gca,'YTick',0:0.1:0.4);
    end
    xlim([0 200000]);
    set(gca,'TickDir','out');
    box on;
    set(l, 'Box', 'off');
    if(i == 6)
        xlabel('Sequence index');
    end
end

clear i cvm lm rm width bm tm cvm height vpos ymax event symbols ws H l;