/* popsim: a simple population simulator
 * Copyright (C) 2004-2006  Jouni K. Seppänen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
*/

#include <assert.h>
#include <limits.h>

#include "famtrack.h"
#include "util.h"

struct famtrack *
ft_init(uint n, uint *familyvec)
{
  struct famtrack *ft = xmalloc(sizeof(struct famtrack));
  uint i;

  assert(n > 0);
  ft->minfamily = UINT_MAX;
  ft->maxfamily = 0;
  for (i=0; i<n; i++) {
    uint f = familyvec[i];
    if (f < ft->minfamily) ft->minfamily = f;
    if (f > ft->maxfamily) ft->maxfamily = f;
  }
  ft->nfamilies = 0;
  ft->fsizes = xcalloc(ft->maxfamily - ft->minfamily + 1, sizeof(uint));
  for (i=0; i<n; i++) {
    uint f = familyvec[i];
    if (0 == ft->fsizes[f-ft->minfamily]++)
      ft->nfamilies++;
  }

  return ft;
}

void
ft_delete(struct famtrack *ft)
{
  xfree(ft->fsizes);
  xfree(ft);
}

void
ft_decrease(struct famtrack *ft, uint fam)
{
  assert(ft->fsizes[fam - ft->minfamily]);
  if (0 == --(ft->fsizes[fam - ft->minfamily])) {
    ft->nfamilies--;
    DEBUG("%u families left that have singles\n", ft->nfamilies);
  }
  DEBUG("family %u has %u singles left\n", fam, ft->fsizes[fam - ft->minfamily]);
}

/* NB -- Keep this in sync with header file. */
uint 
ft_isempty(struct famtrack *ft, uint fam)
{
  return !(ft->fsizes[fam - ft->minfamily]);
}

/* NB -- Keep this in sync with header file. */
void
ft_clear(struct famtrack *ft, uint fam)
{
  ft->fsizes[fam - ft->minfamily] = 0;
}
