/* popsim: a simple population simulator
 * Copyright (C) 2004-2006  Jouni K. Seppänen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
*/

#ifndef UTIL_H
#define UTIL_H

#include <stdio.h>

/* Generic utilities */
void ordremv(uint *array, uint *size, uint elt); /* remove ELT from ordered ARRAY, decrease SIZE */
void *xmalloc(size_t size);	/* malloc that aborts on error */
void *xrealloc(void *ptr, size_t size);
void *xcalloc(size_t nmemb, size_t size);
void xfree(void *ptr);
int compar_uint(const void *a, const void *b); /* qsort/bsearch helper function */
char *xstrdup(const char *str);

#ifdef NDEBUG
#define DEBUG(fmt, ...)
extern inline void 
set_debugging(void) {}
#else
extern int debug_output;
extern inline void 
set_debugging(void)
{
  if (getenv("POPSIM_DEBUG"))
    debug_output = 1;
  else
    debug_output = 0;
}
#define DEBUG(fmt, ...)                          \
  do { if (debug_output) 			 \
          fprintf(stderr, fmt, ## __VA_ARGS__);	 \
  } while(0);
#endif

#endif
