/* popsim: a simple population simulator
 * Copyright (C) 2004-2006  Jouni K. Seppänen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
*/

#include <assert.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "util.h"

#ifndef NDEBUG
int debug_output;
#endif

void
ordremv(uint *array, uint *size, uint elt)
{
  uint *ptr = (uint *)bsearch(&elt, array, *size, sizeof(uint), compar_uint);
  ptrdiff_t pos = ptr - array;

  assert(*size != 0);
  assert(ptr != NULL);
  assert(pos >= 0);
  assert((uint)pos < *size);
  assert(array[pos] == elt);
  assert((pos == 0) || (array[pos-1] < elt));
  assert(((uint)pos == *size-1) || (array[pos+1] > elt));
  if ((uint)pos+1 < *size)
    memmove(array+pos, array+pos+1, (*size-pos-1)*sizeof(uint));
  array[--*size] = 0;
  assert(((uint)pos == *size) || (array[pos] > elt));
  assert((pos == 0) || (array[pos-1] < elt));
}

void *
xmalloc(size_t size)
{
  void *result = malloc(size);
  //fprintf(stderr, "%p: malloc %d bytes\n", result, size);
  if (result)
    return result;
  perror("popsim");
  abort();
}

void *
xrealloc(void *ptr, size_t size)
{
  void *result = realloc(ptr, size);
  //fprintf(stderr, "%p: realloc %d bytes at %p\n", result, size, ptr);
  if (result)
    return result;
  perror("popsim");
  abort();
}

void *
xcalloc(size_t nmemb, size_t size)
{
  void * result = calloc(nmemb, size);
  if (result)
    return result;
  perror("popsim");
  abort();
}

char *
xstrdup(const char *str)
{
  char *result = strdup(str);
  if (result)
    return result;
  perror("popsim");
  abort();
}

void
xfree(void *ptr)
{
  //fprintf(stderr, "%p: free\n", ptr);
  free(ptr);
}

int
compar_uint(const void *a, const void *b)
{
  uint x = *(uint *)a, y = *(uint *)b;
  if (x < y)
    return -1;
  else if (x > y)
    return 1;
  else
    return 0;
}

#ifdef NDEBUG
void
set_debugging(void)
{
}
#else
void
set_debugging(void)
{
  if (getenv("POPSIM_DEBUG"))
    debug_output = 1;
  else
    debug_output = 0;
}
#endif
