/* popsim: a simple population simulator
 * Copyright (C) 2004-2006  Jouni K. Seppänen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
*/

#ifndef PARAMS_H
#define PARAMS_H

#include <stdlib.h>

/* Interface to popsim.c */
extern uint MARKERS;
extern uint INITIAL_POPULATION;
extern uint FINAL_POPULATION;
extern uint GENERATIONS;
int read_conf(const char *fname);
void write_conf(void);
void do_output(void);
void output_histogram(int full, unsigned int samplesize, char *filename);
void plan_population(void);

/* Interface to parser */
extern uint GENLEN;
typedef enum {
  UNSET,
  FROM_TO_NGEN,
  FROM_BY_YEAR_NGEN,
  FROM_BY_GEN_NGEN
} population_rule_t;
extern population_rule_t POPRULE;
extern double POPULATION_GROWTH;
void add_output_rule(int full, uint samplesize, char *filename);

/* Computed parameters */
extern uint *POPULATION_PLAN;

#endif
