function showNeighborhood( X, G, Y)
%VISNEIGHBOURHOOD Draws the neighborhood graph. 
%   Only to be used when the amount of connections in G are sufficiently small.
%   X is a matrix of d column vectors of n data points
%   G is the associated neighborhood matrix
%   Y contains class labels (all assumed to same class if no Y provided)
%   Mika Juuti, 2015-02-20

if nargin < 3
    Y = ones(size(X,1),1);
end

[n,d] = size(X);
dims = [1 2];

figure;
plot(X(:,dims(1)), X(:, dims(2)),'.');
hold on;
colorFun1 = @(x) 0.8 - x.*0.4;
colorFun1 = @(x) 0.6 + x*.4;
colorFun2 = @(x) 0.7 - x.*0.3;
colorFun2 = @(x) 0.8-0.4*(x);
colorFun3 = @(x) 0.7-0.4*(x);
sameClassColorFun = @(x) [colorFun2(x) colorFun3(x) colorFun1(x)];
diffClassColorFun = @(x) [colorFun1(x) colorFun2(x) colorFun3(x)];
classLineStyle = {'-','-'};
giveStyle = @(x) sprintf('%s',classLineStyle{x+1});

G = (G+G')/2;
nn = nnz(G);
if nn <= 10000 % don't overdo the drawing
    for i=1:n
        for j=1:(i-1)
            g = G(i,j);
            sameClass = sum(Y(i,:) ~= Y(j,:))==0; %boolean value
            if ~sameClass && g>0
                [i,j,g];
            end
            if g
                line([X(i,dims(1)) X(j,dims(1))],[X(i,dims(2)) X(j,dims(2))],'Color', ...
                    sameClass*sameClassColorFun(g)+(1-sameClass)*diffClassColorFun(g),'LineWidth',1, ...
                    'LineStyle',giveStyle(sameClass));    
            end
        end
        if n<= 200
            text(X(i,1),X(i,2),num2str(i))
        end
    end
end

hold off;
axis tight;
set(gca,'Xtick',0,'ytick',0);

end

