function [f, grad] = obj_SDPP_sparse(W, X, dy, G, n, lambda)

% obj_SDPP_sparse.m This function returns the SDPP function value and the 
% gradient given a parameter matrix W, the input matrix X, interpoint
% distances dy and a neighborhood graph G. G is assumed to be sparse and
% the supplied dy are calculated with distSqrdSelfsparse.m lambda is a
% ridge regression regularization parameter.
% Mika Juuti, 2014-09-22.

Z = X*W;
[dz,val_g,i,j] = distSqrdSelfsparse(Z,G); % dz is a vector here

dzx = dz -dy; % vector

f = sum(sum(val_g.*(dzx).^2))/n + lambda*sum(sum(W.^2))/n;

n = size(X,1);
gg = sparse(i,j,val_g.*dzx,n,n);
GG = gg;
A = sparse(GG + GG');
D = diag(sum(A,2));
L = D - A;

grad = 4*X'*L*Z/n + 2*lambda*W/n;

