function [f, grad] = obj_SDPP(W, X, Dy, G, n, lambda)

Z = X*W;
Dz = distSqrdSelf(Z);

Dzx = Dz -Dy;

f = sum(sum(G.*(Dzx).^2))/n + lambda*sum(sum(W.^2))/n;

GG = G.*Dzx;
A = GG + GG';
D = diag(sum(A,2));

grad = 4*X'*((D-A)*(X*W))/n + 2*lambda*W/n;

