function [ G ] = naturalNeighbor( X )
%NATURALNEIGHBOR Calculates a neighborhood graph based on adjacent voronoi
%cells. Recommended only if the dimensionality of the data is low.
% Mika Juuti, 2014-09-22

[n,d0] = size(X);

T = delaunayn(X); 

numVertices = size(T,2);
G = sparse(n,n);

for i = 1:size(T,1) %number of triangles
    for j = 1:numVertices
        G(T(i,j), T(i, :)) = 1;
    end
end
G = G - speye(n); 

end

