function knn = fast_approx_knn(X, k, verbose)
if ~exist('verbose', 'var') || isempty(verbose)
    verbose = false;
end

n = size(X,1);

X = X';

J = reshape(repmat(1:n, k, 1), n*k, 1);
I = fastknn_mex(X, k, verbose);
knn = sparse(I, J, ones(n*k,1), n, n, n*k)';