function [dist2,gv,i,j] = distSqrdSelfsparse(x,G,fun,limit,verbose)
% distSqrdSelfsparse.m returns the squared distances, the neighborhood matrix elements and the 
% non-zero columns and rows of G in vector form
% Mika Juuti, 2014-09-22
if nargin <= 2
    fun = @minus;
    if nargin <= 3
        limit = 10^8;
        if nargin <= 4
            verbose = 0;
        end
    end
end
[i,j,gv] = find(G);
nn = nnz(G);
p = size(x,2);
if nn*p>limit % the size of the vector is too large for temporary storage
    if nn > limit
        disp(['Matrix is too large for calculations. Limit: ' num2str(limit) ', nnz: ' num2str(nn) '.'])
        return % cannot be picked apart
    end
    if verbose
       disp('Calculating the squared distance by splitting the data in smaller parts.') 
    end
    partLength = floor(limit / nn); % the nnz times p matrix is split into blocks along the columns
    parts = ceil(p / partLength); % the capacity of the blocks needs to exceed the amount of columns
    dist2 = 0;
    for kk=1:(parts-1)
        if verbose
            disp(['Part ' num2str(kk) ' of ' num2str(parts) '.'])
        end
        sm = bsxfun(fun,x(i,((kk-1)*partLength+1):kk*partLength),x(j,((kk-1)*partLength+1):kk*partLength)); % (partLength times d) matrix
        dist2 = dist2 + sum(bsxfun(@power,sm,2),2);
    end
    if verbose
        disp(['Part ' num2str(parts) ' of ' num2str(parts) '.'])
    end
    sm = bsxfun(fun,x(i,((parts-1)*partLength+1):end),x(j,((parts-1)*partLength+1):end)); % (nnz_G times d) matrix
    dist2 = dist2 + sum(bsxfun(@power,sm,2),2); % an nnz length vector
else
    sm = bsxfun(fun,x(i,:),x(j,:)); % (nnz_G times d) matrix
    dist2 = sum(bsxfun(@power,sm,2),2); % an nnz length vector
end
